WITH TaskTree AS
             (SELECT @RootId AS [Id]
UNION ALL
SELECT p.[ChildTaskId]
FROM [dbo].[ParentTaskExecutions] p
    INNER JOIN TaskTree t
ON t.[Id] = p.[ParentTaskId])
SELECT te.[Id],
       te.[ExecutionMode],
       te.[WorkKind],
       te.[ExecutionType],
       te.[AssignedAgent],
       te.[QueuedAt],
       te.[StartedAt],
       te.[FinishedAt],
       te.[Status],
       te.[InputDataJson],
       te.[OutputDataJson],
       te.[OutputDataRef],
       te.[ErrorMessage],
       te.[CorrelationId],
       te.[ReplayedFromTaskId],
       te.[WorkspaceId],
       te.[AssignmentType],
       te.[ConfidenceScore],
       te.[RetryCount],
       te.[LastRetryAt],
       te.[MaxRetryAttempts],
       te.[RetryReason],
       te.[Priority],
       te.[RetryOfTaskId],
       te.[SuggestionLogId],
       te.[CreatedAt],
       te.[SuggestedPatchJson],
       te.[AiReviewEvidenceManifestJson],
       te.[AiReviewStatus],
       te.[CreatedVia],
       te.[Language], te.[Domain], te.[RepositoryUrl], te.[Branch], te.[FilePath], te.[Prompt], te.[OutputFormat], te.[TriggerSource], te.[ExternalId], te.[ExternalSystem], te.[RowVersion]
FROM [dbo].[TaskExecutions] te
    INNER JOIN TaskTree t
ON t.[Id] = te.[Id]
OPTION (MAXRECURSION 100);
