MERGE [dbo].[TokenUsages] AS T
    USING (VALUES (@Id, @WorkspaceId, @Tokens, @Timestamp, @ReportedAt, @InputTokens, @OutputTokens, @Characters,
    @InputCharacters, @OutputCharacters)) AS S([Id], [WorkspaceId], [Tokens], [Timestamp], [ReportedAt],
    [InputTokens], [OutputTokens], [Characters],
    [InputCharacters], [OutputCharacters])
    ON T.[Id] = S.[Id]
    WHEN MATCHED THEN
UPDATE
    SET T.[WorkspaceId] = S.[WorkspaceId],
    T.[Tokens] = S.[Tokens],
    T.[Timestamp] = S.[Timestamp],
    T.[ReportedAt] = S.[ReportedAt],
    T.[InputTokens] = S.[InputTokens],
    T.[OutputTokens] = S.[OutputTokens],
    T.[Characters] = S.[Characters],
    T.[InputCharacters] = S.[InputCharacters],
    T.[OutputCharacters] = S.[OutputCharacters]
    WHEN NOT MATCHED THEN
INSERT
(
[Id],
[WorkspaceId],
[Tokens],
[Timestamp],
[ReportedAt],
[InputTokens],
[OutputTokens],
[Characters],
[InputCharacters],
[OutputCharacters])
VALUES (S.[Id], S.[WorkspaceId], S.[Tokens], S.[Timestamp], S.[ReportedAt], S.[InputTokens], S.[OutputTokens], S.[Characters], S.[InputCharacters], S.[OutputCharacters]);
